import os
import shutil
import re
from tqdm import tqdm

base_folder = 'datasets/box2d_default'  # Replace with the path to your base folder
source_folder = os.path.join(base_folder, '0')
images_per_folder = 2000

def get_state_number(filename):
    # Extract the state number from the filename
    match = re.search(r'state(\d+)_', filename)
    return int(match.group(1)) if match else None

def move_file_to_subfolder(file_path, subfolder_path):
    os.makedirs(subfolder_path, exist_ok=True)
    shutil.move(file_path, subfolder_path)

# Iterate over each file in the source folder
for file_name in tqdm(os.listdir(source_folder)):
    file_path = os.path.join(source_folder, file_name)
    
    # Get the state number from the file name
    state_number = get_state_number(file_name)
    if state_number is not None and state_number >= 2000:
        # Determine the target subfolder
        folder_index = state_number // images_per_folder
        target_folder = os.path.join(base_folder, str(folder_index))

        # Move the file to the target subfolder
        move_file_to_subfolder(file_path, target_folder)